/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.items.ItemRock;
import dangerzone.DangerZone;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.threads.LightingThread;
import org.newdawn.slick.opengl.Texture;

public class Rock
extends EntityLiving {
    Texture texture2 = null;
    Texture texture3 = null;
    Texture texture4 = null;
    Texture texture5 = null;
    Texture texture6 = null;
    Texture texture7 = null;
    Texture texture8 = null;
    Texture texture9 = null;
    Texture texture10 = null;
    public static Item rocksmall = new ItemRock("OreSpawn:Small Rock", "orespawnres/items/rocksmall.png", 1);
    public static Item rock = new ItemRock("OreSpawn:Rock", "orespawnres/items/rock.png", 2);
    public static Item rockred = new ItemRock("OreSpawn:Red Rock", "orespawnres/items/rockred.png", 3);
    public static Item rockgreen = new ItemRock("OreSpawn:Green Rock", "orespawnres/items/rockgreen.png", 4);
    public static Item rockblue = new ItemRock("OreSpawn:Blue Rock", "orespawnres/items/rockblue.png", 5);
    public static Item rockpurple = new ItemRock("OreSpawn:Purple Rock", "orespawnres/items/rockpurple.png", 6);
    public static Item rocktnt = new ItemRock("OreSpawn:Explosive Rock", "orespawnres/items/rocktnt.png", 7);
    public static Item rockspikey = new ItemRock("OreSpawn:Spikey Rock", "orespawnres/items/rockspikey.png", 8);
    public static Item rockcrystalblue = new ItemRock("OreSpawn:Blue Crystal Rock", "orespawnres/items/rockcrystalblue.png", 11);
    public static Item rockcrystalgreen = new ItemRock("OreSpawn:Green Crystal Rock", "orespawnres/items/rockcrystalgreen.png", 10);
    public static Item rockcrystalred = new ItemRock("OreSpawn:Red Crystal Rock", "orespawnres/items/rockcrystalred.png", 9);
    public static Item rockcrystaltnt = new ItemRock("OreSpawn:Explosive Crystal Rock", "orespawnres/items/rockcrystaltnt.png", 12);

    public Rock(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.5f;
        this.width = 0.33f;
        this.uniquename = "OreSpawn:Rock";
        this.moveSpeed = 0.0f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 4000;
        this.setExperience(1);
        this.canSwim = false;
        this.daytimespawn = true;
        this.nighttimespawn = true;
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
    }

    public void init() {
        super.init();
        if (this.getBID() == 0) {
            if (this.dimension == OreSpawnMain.crystaldimension.dimensionID) {
                this.setBID(9);
                if (DangerZone.rand.nextInt(3) == 0) {
                    this.setBID(10);
                }
                if (DangerZone.rand.nextInt(5) == 0) {
                    this.setBID(11);
                }
                if (DangerZone.rand.nextInt(10) == 0) {
                    this.setBID(12);
                }
            } else {
                this.setBID(1);
                if (DangerZone.rand.nextInt(10) == 0) {
                    this.setBID(2);
                }
                if (DangerZone.rand.nextInt(20) == 0) {
                    this.setBID(3);
                }
                if (DangerZone.rand.nextInt(30) == 0) {
                    this.setBID(4);
                }
                if (DangerZone.rand.nextInt(40) == 0) {
                    this.setBID(5);
                }
                if (DangerZone.rand.nextInt(50) == 0) {
                    this.setBID(6);
                }
                if (DangerZone.rand.nextInt(100) == 0) {
                    this.setBID(8);
                }
                if (DangerZone.rand.nextInt(200) == 0) {
                    this.setBID(7);
                }
                if (DangerZone.rand.nextInt(500) == 0) {
                    this.setBID(9);
                }
                if (DangerZone.rand.nextInt(500) == 0) {
                    this.setBID(10);
                }
                if (DangerZone.rand.nextInt(500) == 0) {
                    this.setBID(11);
                }
                if (DangerZone.rand.nextInt(1000) == 0) {
                    this.setBID(12);
                }
            }
        }
    }

    public void doEntityAction(float deltaT) {
        if (this.getBID() != 0 && this.getMaxHealth() != (float)this.getBID()) {
            this.setMaxHealth(this.getBID());
            this.setHealth(this.getBID());
        }
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            if (this.getBID() == 12) {
                if (this.world.rand.nextInt(50) == 1) {
                    Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleFire", (int)3, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (boolean)false);
                }
                if (this.world.rand.nextInt(50) == 1) {
                    Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleSparkle", (int)3, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz, (boolean)false);
                }
            }
            if (this.getBID() >= 9 && this.world.rand.nextInt(120) == 1) {
                LightingThread.addRequest((int)this.dimension, (int)((int)this.posx), (int)((int)this.posy), (int)((int)this.posz), (float)0.35f);
            }
        }
        if (this.world.isServer && this.getExperience() > 0 && this.getIID() == 100) {
            this.setExperience(0);
        }
        super.update(deltaT);
    }

    public String getDeathSound() {
        return "DangerZone:pop";
    }

    public String getHurtSound() {
        return "DangerZone:pop";
    }

    public void doDeathDrops() {
        int rt = this.getBID();
        int newID = 0;
        if (rt == 1) {
            newID = OreSpawnMain.rocksmall.itemID;
        }
        if (rt == 2) {
            newID = OreSpawnMain.rock.itemID;
        }
        if (rt == 3) {
            newID = OreSpawnMain.rockred.itemID;
        }
        if (rt == 4) {
            newID = OreSpawnMain.rockgreen.itemID;
        }
        if (rt == 5) {
            newID = OreSpawnMain.rockblue.itemID;
        }
        if (rt == 6) {
            newID = OreSpawnMain.rockpurple.itemID;
        }
        if (rt == 7) {
            newID = OreSpawnMain.rocktnt.itemID;
        }
        if (rt == 8) {
            newID = OreSpawnMain.rockspikey.itemID;
        }
        if (rt == 9) {
            newID = OreSpawnMain.rockcrystalred.itemID;
        }
        if (rt == 10) {
            newID = OreSpawnMain.rockcrystalgreen.itemID;
        }
        if (rt == 11) {
            newID = OreSpawnMain.rockcrystalblue.itemID;
        }
        if (rt == 12) {
            newID = OreSpawnMain.rockcrystaltnt.itemID;
        }
        if (newID != 0) {
            Utils.doDropRand((World)this.world, (int)0, (int)newID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public int getRockType() {
        return this.getBID();
    }

    public Texture getTexture() {
        int rt;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Rocktexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/RockTNTtexture.png");
            this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/RockRedtexture.png");
            this.texture4 = TextureMapper.getTexture((String)"orespawnres/skins/RockBluetexture.png");
            this.texture5 = TextureMapper.getTexture((String)"orespawnres/skins/RockGreentexture.png");
            this.texture6 = TextureMapper.getTexture((String)"orespawnres/skins/RockPurpletexture.png");
            this.texture7 = TextureMapper.getTexture((String)"orespawnres/skins/RockCrystalRedtexture.png");
            this.texture8 = TextureMapper.getTexture((String)"orespawnres/skins/RockCrystalGreentexture.png");
            this.texture9 = TextureMapper.getTexture((String)"orespawnres/skins/RockCrystalBluetexture.png");
            this.texture10 = TextureMapper.getTexture((String)"orespawnres/skins/RockCrystalTNTtexture.png");
        }
        if ((rt = this.getBID()) == 3) {
            return this.texture3;
        }
        if (rt == 4) {
            return this.texture5;
        }
        if (rt == 5) {
            return this.texture4;
        }
        if (rt == 6) {
            return this.texture6;
        }
        if (rt == 7) {
            return this.texture2;
        }
        if (rt == 9) {
            return this.texture7;
        }
        if (rt == 10) {
            return this.texture8;
        }
        if (rt == 11) {
            return this.texture9;
        }
        if (rt == 12) {
            return this.texture10;
        }
        return this.texture;
    }
}

